<?php include 'includes/tema/topo.php'; ?>

<style>
/* Estilos específicos para a linha de totais dinâmicos */
#totais-dinamicos {
    position: sticky;
    bottom: 0;
    z-index: 100;
    transition: all 0.3s ease;
}

/* Responsividade para dispositivos móveis */
@media (max-width: 767px) {
    #totais-dinamicos .row {
        flex-direction: column !important;
        align-items: flex-start !important;
        gap: 15px !important;
    }
    
    #totais-dinamicos .totais-valores {
        flex-direction: column !important;
        gap: 12px !important;
        margin-top: 10px !important;
        width: 100%;
    }
    
    #totais-dinamicos .totais-valores > div {
        justify-content: space-between;
        width: 100%;
        padding: 8px 12px;
        background: rgba(255,255,255,0.8);
        border-radius: 8px;
        border: 1px solid #e0e0e0;
    }
}

/* Melhorar contraste em telas pequenas */
@media (max-width: 576px) {
    #totais-dinamicos {
        padding: 15px 10px !important;
        font-size: 12px;
    }
    
    #totais-dinamicos .totais-valores span {
        font-size: 12px !important;
    }
}

/* Animação suave para os valores dos totais */
#total-vendas-filtrado, #total-pagamentos-filtrado, #diferenca-total-filtrado {
    transition: all 0.3s ease;
}

/* Efeito hover nos badges dos totais */
#totais-dinamicos .totais-valores > div:hover span[id*="total"] {
    transform: scale(1.05);
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}

/* Garantir que a tabela tenha overflow controlado */
.dt-responsive {
    overflow-x: auto;
    position: relative;
}

/* Ajustar espaçamento do DataTable */
.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter,
.dataTables_wrapper .dataTables_info,
.dataTables_wrapper .dataTables_paginate {
    margin: 0.5em 0;
}

/* Melhorar visual dos inputs de busca no footer */
.footer-search-input {
    transition: all 0.3s ease;
    font-size: 12px !important;
}

.footer-search-input:focus {
    background-color: #fff3cd !important;
    border-color: #ffc107 !important;
    box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.25) !important;
}

/* Indicador visual para linhas filtradas */
#footer-search tbody tr.filtered-out {
    opacity: 0.5;
    transition: opacity 0.3s ease;
}

/* Melhorar visual da info do DataTable */
.dataTables_info {
    font-size: 13px;
    color: #6c757d;
    font-weight: 500;
}

/* Destaque para totais dinâmicos durante atualização */
#totais-dinamicos.updating {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%) !important;
    border-color: #ffc107 !important;
}

/* Estilos para o sistema de calculadora melhorado - Versão Discreta */
.calculadora-wrapper {
    display: inline-flex;
    align-items: center;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    cursor: pointer;
    position: relative;
    padding: 2px 4px;
    border-radius: 6px;
    max-width: 24px;
    overflow: hidden;
    white-space: nowrap;
}

.calculadora-wrapper:hover {
    max-width: 200px;
    padding: 4px 8px;
    background: rgba(255, 255, 255, 0.95);
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    border: 1px solid rgba(0,0,0,0.1);
    transform: translateY(-1px);
}

.calculadora-wrapper::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, transparent, rgba(103, 126, 234, 0.05), transparent);
    border-radius: 6px;
    opacity: 0;
    transition: opacity 0.4s ease;
    z-index: -1;
}

.calculadora-wrapper:hover::before {
    opacity: 1;
}

/* Badge inicial discreta - apenas ícone */
.badge-calculadora {
    font-weight: 600;
    letter-spacing: 0.3px;
    text-shadow: 0 1px 2px rgba(0,0,0,0.1);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 1px 2px rgba(0,0,0,0.1);
    position: relative;
    overflow: hidden;
    font-size: 0px !important; /* Inicialmente esconde o texto */
    padding: 3px !important;
    min-width: 20px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

/* Texto da badge - inicialmente escondido */
.badge-text {
    opacity: 0;
    max-width: 0;
    overflow: hidden;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    margin-left: 0;
    white-space: nowrap;
}

/* Estado expandido no hover */
.calculadora-wrapper:hover .badge-calculadora {
    font-size: 11px !important;
    padding: 4px 8px !important;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.calculadora-wrapper:hover .badge-text {
    opacity: 1;
    max-width: 150px;
    margin-left: 4px;
}

.badge-calculadora::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
    transition: left 0.6s ease;
}

.calculadora-wrapper:hover .badge-calculadora::before {
    left: 100%;
}

/* Ícone da calculadora com alta qualidade */
.calculadora-wrapper i.fa-calculator-alt {
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    filter: drop-shadow(0 1px 2px rgba(0,0,0,0.1));
    opacity: 0;
    transform: scale(0.8);
    margin-left: 0;
    font-size: 12px;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    text-rendering: optimizeLegibility;
    font-feature-settings: "liga" 1;
    transform: translateZ(0) scale(0.8);
    backface-visibility: hidden;
    font-weight: 900;
}

.calculadora-wrapper:hover i.fa-calculator-alt {
    opacity: 1;
    transform: translateZ(0) scale(1) rotate(5deg);
    filter: drop-shadow(0 2px 4px rgba(0,0,0,0.2));
    margin-left: 6px;
}

/* Indicador de status discreto */
.status-indicator {
    width: 6px;
    height: 6px;
    border-radius: 50%;
    position: absolute;
    top: -1px;
    right: -1px;
    transition: all 0.3s ease;
    opacity: 0.7;
}

.calculadora-wrapper:hover .status-indicator {
    opacity: 0;
}

/* Modal da calculadora */
.modal-calculadora .modal-content {
    border-radius: 15px;
    border: none;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
    overflow: hidden;
}

/* Garantir que apenas um modal seja visível */
.modal-calculadora {
    z-index: 1060; /* Prioridade alta */
}

/* Esconder tooltips quando modal estiver aberto */
body.modal-open .tooltip-calculadora {
    display: none !important;
}

/* Prevenir múltiplos modais da calculadora */
.modal-calculadora.show ~ .modal-calculadora {
    display: none !important;
}

.modal-calculadora .modal-header {
    border-radius: 15px 15px 0 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-bottom: none;
    position: relative;
}

.modal-calculadora .modal-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
    opacity: 0.3;
}

.modal-calculadora .btn-close-custom {
    background: rgba(255,255,255,0.2);
    border: 1px solid rgba(255,255,255,0.3);
    color: white;
    border-radius: 50%;
    width: 35px;
    height: 35px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    position: relative;
    z-index: 10;
}

.modal-calculadora .btn-close-custom:hover {
    background: rgba(255,255,255,0.3);
    transform: rotate(90deg) scale(1.1);
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.status-card {
    border-radius: 12px;
    border: none;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.status-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: linear-gradient(90deg, #667eea, #764ba2);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.status-card:hover::before {
    opacity: 1;
}

.status-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 15px rgba(0,0,0,0.15);
}

.valor-destaque {
    font-size: 1.8rem;
    font-weight: 700;
    text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    position: relative;
}

.valor-destaque::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 50%;
    transform: translateX(-50%);
    width: 0;
    height: 2px;
    background: currentColor;
    transition: width 0.3s ease;
}

.status-card:hover .valor-destaque::after {
    width: 60%;
}

.status-icon {
    font-size: 2.5rem;
    margin-bottom: 10px;
    transition: all 0.3s ease;
}

.status-card:hover .status-icon {
    transform: scale(1.1) rotate(5deg);
}

/* Progress bar melhorada */
.progress {
    border-radius: 10px;
    overflow: hidden;
    box-shadow: inset 0 2px 4px rgba(0,0,0,0.1);
}

.progress-bar {
    position: relative;
    overflow: hidden;
}

.progress-bar::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, transparent 25%, rgba(255,255,255,0.2) 25%, rgba(255,255,255,0.2) 50%, transparent 50%, transparent 75%, rgba(255,255,255,0.2) 75%);
    background-size: 20px 20px;
    animation: move-bg 1s linear infinite;
}

@keyframes move-bg {
    0% { background-position: 0 0; }
    100% { background-position: 20px 0; }
}

/* Botões de ação rápida melhorados */
.modal-calculadora .btn {
    border-width: 2px;
    font-weight: 600;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.modal-calculadora .btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: currentColor;
    opacity: 0.1;
    transition: left 0.3s ease;
}

.modal-calculadora .btn:hover::before {
    left: 0;
}

.modal-calculadora .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

/* Animações suaves */
@keyframes pulse-badge {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); }
    100% { transform: scale(1); }
}

@keyframes click-effect {
    0% { transform: scale(1); }
    50% { transform: scale(0.95); }
    100% { transform: scale(1); }
}

@keyframes expand-hint {
    0% { transform: scale(1); }
    50% { transform: scale(1.02); }
    100% { transform: scale(1); }
}

.badge-calculadora.pulse {
    animation: pulse-badge 2s infinite;
}

.calculadora-wrapper.clicked {
    animation: click-effect 0.2s ease;
}

/* Efeito de "respiração" para indicar interatividade */
.calculadora-wrapper:not(:hover) .badge-calculadora {
    animation: expand-hint 3s ease-in-out infinite;
}

/* Tooltip melhorado com ícones de alta qualidade */
.tooltip-inner {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    max-width: 250px;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

/* CSS GLOBAL para máxima qualidade de ícones FontAwesome */
[class*="fa-"],
.fa,
.fas,
.far,
.fal,
.fab,
.fad {
    -webkit-font-smoothing: antialiased !important;
    -moz-osx-font-smoothing: grayscale !important;
    text-rendering: optimizeLegibility !important;
    font-display: block !important;
    image-rendering: -webkit-optimize-contrast !important;
    image-rendering: crisp-edges !important;
    backface-visibility: hidden !important;
    transform: translateZ(0) !important;
    will-change: transform !important;
    font-variant-ligatures: none !important;
    font-feature-settings: "liga" 0 !important;
    font-weight: inherit !important;
    
    /* Especial para WebKit/Blink */
    -webkit-backface-visibility: hidden !important;
    -webkit-transform: translateZ(0) translate3d(0,0,0) !important;
    
    /* Anti-aliasing específico para diferentes engines */
    -webkit-font-feature-settings: "liga" 0 !important;
    -moz-font-feature-settings: "liga" 0 !important;
    font-kerning: none !important;
}

/* Melhorar qualidade dos ícones no tooltip */
.tooltip-calculadora .fas {
    -webkit-font-smoothing: antialiased !important;
    -moz-osx-font-smoothing: grayscale !important;
    text-rendering: optimizeLegibility !important;
    font-feature-settings: "liga" 1;
    transform: translateZ(0); /* Força aceleração de hardware */
    backface-visibility: hidden;
    font-weight: 900; /* Ícones mais nítidos */
}

/* Melhoria global para ícones FontAwesome */
.fas, .far, .fab, .fal {
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    text-rendering: optimizeLegibility;
    font-feature-settings: "liga" 1;
}

/* Otimização para displays de alta densidade (Retina, 4K) */
@media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
    .tooltip-calculadora .fas,
    .calculadora-wrapper i.fas {
        transform: translateZ(0) scale(1.001); /* Micro-escala para melhor renderização */
    }
}

/* Ícones de status no modal - qualidade cristalina */
.status-icon {
    -webkit-font-smoothing: antialiased !important;
    -moz-osx-font-smoothing: grayscale !important;
    text-rendering: optimizeLegibility !important;
    font-feature-settings: "liga" 1;
    transform: translateZ(0);
    backface-visibility: hidden;
    font-weight: 900 !important;
    filter: contrast(1.1) brightness(1.05);
}

/* Ícone fa-exclamation-triangle específico - correção de qualidade MÁXIMA */
.fas.fa-exclamation-triangle,
i.fas.fa-exclamation-triangle,
.fa-exclamation-triangle {
    -webkit-font-smoothing: antialiased !important;
    -moz-osx-font-smoothing: grayscale !important;
    text-rendering: optimizeLegibility !important;
    font-weight: 900 !important;
    transform: translateZ(0) scale(1.002) !important;
    backface-visibility: hidden !important;
    filter: contrast(1.2) brightness(1.15) saturate(1.1) !important;
    image-rendering: crisp-edges !important;
    image-rendering: -webkit-optimize-contrast !important;
    font-display: block !important;
    will-change: transform !important;
    font-variant-ligatures: none !important;
    font-feature-settings: "liga" 0 !important;
    
    /* Para displays de alta densidade */
    @media only screen and (-webkit-min-device-pixel-ratio: 2), 
           only screen and (min--moz-device-pixel-ratio: 2), 
           only screen and (-o-min-device-pixel-ratio: 2/1), 
           only screen and (min-device-pixel-ratio: 2),
           only screen and (min-resolution: 192dpi),
           only screen and (min-resolution: 2dppx) {
        transform: translateZ(0) scale(1.0005) !important;
        filter: contrast(1.25) brightness(1.2) saturate(1.15) !important;
    }
}

/* Classe específica para ícones de status críticos */
.status-icon {
    -webkit-font-smoothing: antialiased !important;
    -moz-osx-font-smoothing: grayscale !important;
    text-rendering: optimizeLegibility !important;
    font-weight: 900 !important;
    transform: translateZ(0) scale(1.001) !important;
    backface-visibility: hidden !important;
    will-change: transform !important;
    image-rendering: -webkit-optimize-contrast !important;
    font-display: block !important;
    font-variant-ligatures: none !important;
    font-feature-settings: "liga" 0 !important;
}

/* Melhorar a transição do tooltip */
.tooltip {
    transition: opacity 0.3s ease;
}

/* Estado de foco para acessibilidade */
.calculadora-wrapper:focus {
    outline: 2px solid rgba(103, 126, 234, 0.5);
    outline-offset: 2px;
    border-radius: 8px;
}

.calculadora-wrapper:focus:not(:hover) {
    max-width: 180px;
    padding: 4px 6px;
    background: rgba(255, 255, 255, 0.9);
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.calculadora-wrapper:focus:not(:hover) .badge-calculadora {
    font-size: 10px !important;
    padding: 3px 6px !important;
}

.calculadora-wrapper:focus:not(:hover) .badge-text {
    opacity: 0.8;
    max-width: 120px;
    margin-left: 3px;
}

/* Responsividade para calculadora discreta */
@media (max-width: 768px) {
    .calculadora-wrapper {
        max-width: 22px;
        padding: 2px 3px;
    }
    
    .calculadora-wrapper:hover,
    .calculadora-wrapper:focus {
        max-width: 160px;
        padding: 3px 6px;
    }
    
    .badge-calculadora {
        font-size: 0px !important;
        padding: 2px !important;
        min-width: 18px;
    }
    
    .calculadora-wrapper:hover .badge-calculadora,
    .calculadora-wrapper:focus .badge-calculadora {
        font-size: 10px !important;
        padding: 3px 6px !important;
    }
    
    .calculadora-wrapper:hover .badge-text,
    .calculadora-wrapper:focus .badge-text {
        max-width: 120px;
        margin-left: 3px;
    }
    
    .calculadora-wrapper i.fa-calculator-alt {
        font-size: 10px;
        margin-left: 0;
    }
    
    .calculadora-wrapper:hover i.fa-calculator-alt {
        margin-left: 4px;
        font-size: 11px;
    }
    
    .modal-calculadora .modal-dialog {
        margin: 10px;
        max-width: calc(100% - 20px);
    }
    
    /* Tooltip mais compacto em mobile */
    .tooltip-inner {
        max-width: 280px !important;
        font-size: 12px;
    }
}

/* Para telas muito pequenas (smartphones em portrait) */
@media (max-width: 576px) {
    .calculadora-wrapper {
        max-width: 20px;
        margin-left: 4px !important;
    }
    
    .calculadora-wrapper:hover,
    .calculadora-wrapper:focus {
        max-width: 140px;
    }
    
    .badge-calculadora {
        min-width: 16px;
    }
    
    .calculadora-wrapper:hover .badge-text,
    .calculadora-wrapper:focus .badge-text {
        max-width: 100px;
        font-size: 9px;
    }
    
    .status-indicator {
        width: 4px;
        height: 4px;
        top: 0;
        right: 0;
    }
    
    /* Tooltip ainda mais compacto */
    .tooltip-inner {
        max-width: 250px !important;
        font-size: 11px;
        padding: 8px 10px;
    }
}

/* Estados especiais para dispositivos touch */
@media (hover: none) {
    .calculadora-wrapper {
        max-width: 26px; /* Ligeiramente maior em dispositivos touch */
    }
    
    /* Em dispositivos touch, expandir no tap/focus */
    .calculadora-wrapper:focus,
    .calculadora-wrapper:active {
        max-width: 180px;
        padding: 4px 8px;
        background: rgba(255, 255, 255, 0.95);
        box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    }
    
    .calculadora-wrapper:focus .badge-calculadora,
    .calculadora-wrapper:active .badge-calculadora {
        font-size: 11px !important;
        padding: 4px 8px !important;
    }
    
    .calculadora-wrapper:focus .badge-text,
    .calculadora-wrapper:active .badge-text {
        opacity: 1;
        max-width: 150px;
        margin-left: 4px;
    }
    
    .calculadora-wrapper:focus i.fa-calculator-alt,
    .calculadora-wrapper:active i.fa-calculator-alt {
        opacity: 1;
        margin-left: 6px;
    }
}
</style>

<?

$acao = antiSQL($_GET['acao']);		
$idpedido = antiSQL($_GET['id_pedido']);
		
$Inserir = antiSQL($_POST['Inserir']);
$Alterar = antiSQL($_POST['Alterar']);
$Excluir = antiSQL($_GET['Excluir']);

$id_cliente = antiSQL($_POST['id_cliente']);	
$id_produto = antiSQL($_POST['id_produto']);
$data = antiSQL(date("d/m/Y"));
$hora = antiSQL(date("H:i"));		
$status = antiSQL($_POST['status']);			




$checa_pedidos = mysqli_query($conn,"SELECT * FROM pedidos ")->fetch_array(); 

if($checa_pedidos['id_cliente'] == $id_cliente){

    echo 'Já existe pedido cadastrado para este cliente';


}else{

if ($Inserir == "ok") {
mysqli_query($conn,"INSERT INTO pedidos (id_cliente,data,hora) VALUES ('$id_cliente','$data','$hora')");
header( 'Location: pedidos.php?cadastrado_sucesso=sim');
}

}		

if ($Alterar == "ok"){
mysqli_query($conn,"UPDATE pedidos SET id_cliente='$id_cliente',data='$data',hora='$hora' WHERE id=$idpedido");
	
header( 'Location: pedidos.php?alterado_sucesso=sim');
}

if ($Excluir == "ok") {	
    mysqli_query($conn,"DELETE FROM pedidos WHERE id=$idpedido");
    mysqli_query($conn,"ALTER TABLE pedidos AUTO_INCREMENT = 1");	
    header('Location: pedidos.php?deletado_sucesso=sim');
} 




?>

<section class="pc-container">
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0)">Menu</a></li>
                            <li class="breadcrumb-item" aria-current="page">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12">
                        <div class="page-header-title">
                            <h2 class="mb-0">
                                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                                echo ucfirst(strtolower($pagina)); ?>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- [ breadcrumb ] end -->

            <? if ($acao == "Alterar") { 
             $sql = mysqli_query($conn,"SELECT * FROM pedidos WHERE id=$idpedido")->fetch_array(); 
             
             } ?>

            <? if ($acao != "") { ?>
            <div class="smart-wrap">
                <div class="smart-forms smart-container wrap-0">
                    <div class="form-header header-blue ">
                        <h4><i class="fa fa-calendar-o"></i> Pedidos  </h4>
                    </div><!-- end .form-header section -->



                    <form name="usuarios" id="usuarios" method="post" action="<?php echo $_SERVER['PHP_SELF']?>"
                        enctype="multipart/form-data">


                        <div class="form-body">


                            <div class="spacer-b30">
                                <div class="tagline"><span style="color: black"> Cliente</span></div><!-- .tagline -->
                            </div>

                            <div class="frm-row">
                                <div class="section colm colm4">
                                </div>
                                <div class="section colm colm4">
                                    <label class="field select prepend-icon">

                                        <select name="id_cliente" class="example-data-array smart-select2 select2-hidden-accessible" style="width:100%"
                                        tabindex="-1" aria-hidden="true">
                                        <option value="">Selecionar Cliente</option>
                                            <? $sqla = mysqli_query($conn,"SELECT * FROM usuarios ORDER BY id");
while ($coluna = mysqli_fetch_array($sqla)) { ?>

                                            <option value="<? echo $coluna[id]?>" <? if
                                                ($sql['id_cliente']==$coluna[id]) echo " selected" ; ?> >
                                                <span style="color: "><? echo $coluna[nome]?></span>
                                            </option>
                                            <? } ?>
                                        </select> <span class="field-icon"><i class="fa fa-user"></i></span> <b
                                            class="tooltip tip-right-top"><b>Selecione o <span
                                                    style="color:#6CF;">Cliente</span> Exemplo: <span
                                                    style="color:#6CF;"> Usuario </span></b></b> </label>
                                </div>
                            </div>










                        </div>




                        <div class="form-footer" align="center">
                            <input type="hidden" name="id_pedido" value="<?php echo $idpedido; ?>">
                            <input type="hidden" name="<?php echo $acao; ?>" value="ok">
                            <input type="submit" class="button btn-blue" name="Submit" value="<?php echo $acao; ?>">

                        </div>

                    </form>
                </div>
            </div>



            <div class="row page-titles">

<div class="col-md-7 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='<? $pagina = basename($_SERVER['PHP_SELF'], ''); echo $pagina; ?>';"><i
                class="fa fa-plus-circle"></i>
            Voltar</button>
    </div>
</div>
</div>


            <? } else { ?>


                <div style="clear: both;"></div>


<div class="col-sm-12">
    <div class="card">
        <div class="card-header">
            <h5>Tabela:
                <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                    echo ucfirst(strtolower($pagina)); ?>
            </h5>
            <small>Aqui você tem as opções de <b>cadastrar</b>,<b>editar</b>,<b>excluir</b> <span
                    style="color:red;">
                    <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
                        echo ucfirst(strtolower($pagina)); ?><span>.</small>
        </div>
        <div class="card-body">
            <div class="dt-responsive table-responsive">

                <table id="footer-search" class="table table-striped table-bordered nowrap">                                <thead>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;color:green" >Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead><tfoot>
                                    <tr>
                                        <th style="width: 5%">N° </th>
                                        <th style="width: 25%;">Cliente</th>
                                        <th style="width: 15%;">Empresa</th>
                                        <th style="width: 11%;" >Vendas</th>
                                        <th style="width: 11%;">Pagamentos</th>
                                        <th style="width: 7%">Data</th>
                                        <th>Ações</th>
                                    </tr>                                </tfoot><tbody>                                    <?
                                    // OTIMIZAÇÃO: Uma única query com JOINs para buscar todos os dados necessários
                                    $sqlpedidos = mysqli_query($conn,"
                                        SELECT 
                                            p.id,
                                            p.id_cliente,
                                            p.data,
                                            u.nome as cliente_nome,
                                            u.id_empresa,
                                            e.empresa as empresa_nome,
                                            COALESCE(v.total_vendas, 0) as total_vendas,
                                            COALESCE(f.total_pagamentos, 0) as total_pagamentos
                                        FROM pedidos p
                                        LEFT JOIN usuarios u ON p.id_cliente = u.id
                                        LEFT JOIN empresas e ON u.id_empresa = e.id
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_vendas 
                                            FROM vendas 
                                            GROUP BY id_pedido
                                        ) v ON p.id = v.id_pedido
                                        LEFT JOIN (
                                            SELECT id_pedido, SUM(valor) as total_pagamentos 
                                            FROM financeiro_clientes 
                                            GROUP BY id_pedido
                                        ) f ON p.id = f.id_pedido
                                        ORDER BY p.id ASC
                                    ");
                                    
                                    while ($pedidos = mysqli_fetch_array($sqlpedidos)) { 
                                        $total_vendas = floatval($pedidos['total_vendas']);
                                        $total_pagamentos = floatval($pedidos['total_pagamentos']);
                                        $diferenca = $total_vendas - $total_pagamentos;
                                    ?>                                    <tr>
                                        <td style="width: 5%"> 
                                            <? echo $pedidos['id']; ?>  
                                        </td>
                                        <td> 
                                            <a href="usuarios.php?acao=Alterar&id_usuario=<?php echo $pedidos['id_cliente'];?>">
                                                <?php echo $pedidos['cliente_nome']; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <a href="empresas.php?acao=Alterar&id_empresas=<?php echo $pedidos['id_empresa'];?>">
                                                <?php echo $pedidos['empresa_nome']; ?>
                                            </a>
                                        </td><td style="width: 12%;" data-vendas="<?php echo $total_vendas; ?>">
                                            <?php echo 'R$ '.number_format($total_vendas, 2, "," , "." ); ?>
                                        </td>                        <td style="width: 7%" data-pagamentos="<?php echo $total_pagamentos; ?>">
                            <?php echo 'R$ '.number_format($total_pagamentos, 2, "," , "." ); ?>
                            
                            <!-- Sistema de Calculadora Melhorado -->
                            <?php 
                            $diferenca_pedido = $total_vendas - $total_pagamentos;
                            $status_financeiro = '';
                            $cor_status = '';
                            $icone_status = '';
                            
                            if ($diferenca_pedido > 0) {
                                $status_financeiro = 'Falta Pagar';
                                $cor_status = '#dc3545'; // Vermelho
                                $icone_status = 'fa-exclamation-triangle';
                            } elseif ($diferenca_pedido < 0) {
                                $status_financeiro = 'Há a Receber';
                                $cor_status = '#28a745'; // Verde
                                $icone_status = 'fa-check-circle';
                            } else {
                                $status_financeiro = 'Quitado';
                                $cor_status = '#6c757d'; // Cinza
                                $icone_status = 'fa-balance-scale';
                            }
                            ?>                            <!-- Sistema de Calculadora Melhorado - Versão Discreta -->
                            <span class="calculadora-wrapper ml-2" 
                                  data-pedido-id="<?php echo $pedidos['id']; ?>"
                                  data-cliente-nome="<?php echo htmlspecialchars($pedidos['cliente_nome']); ?>"
                                  data-cliente-id="<?php echo $pedidos['id_cliente']; ?>"
                                  data-vendas="<?php echo $total_vendas; ?>"
                                  data-pagamentos="<?php echo $total_pagamentos; ?>"
                                  data-diferenca="<?php echo abs($diferenca_pedido); ?>"
                                  data-status="<?php echo $status_financeiro; ?>"
                                  tabindex="0"
                                  role="button"
                                  aria-label="Calculadora financeira - <?php echo $status_financeiro; ?>: R$ <?php echo number_format(abs($diferenca_pedido), 2, "," , "." ); ?>">
                                  <!-- Badge discreta - inicialmente só ícone -->
                                <span class="badge badge-calculadora" 
                                      style="background-color: <?php echo $cor_status; ?>; color: white; border-radius: 10px; position: relative;">                                    <!-- Ícone do status (sempre visível) com alta qualidade -->
                                    <i class="fas <?php echo $icone_status; ?> status-icon" 
                                       style="font-size: 12px; 
                                              -webkit-font-smoothing: antialiased !important; 
                                              -moz-osx-font-smoothing: grayscale !important; 
                                              text-rendering: optimizeLegibility !important; 
                                              font-weight: 900 !important;
                                              transform: translateZ(0) scale(1.002) !important;
                                              backface-visibility: hidden !important;
                                              filter: contrast(1.2) brightness(1.15) saturate(1.1) !important;
                                              image-rendering: -webkit-optimize-contrast !important;" 
                                       aria-hidden="true"></i>
                                    
                                    <!-- Texto expandido (visível apenas no hover) -->
                                    <span class="badge-text">
                                        <span class="sr-only"><?php echo $status_financeiro; ?>: </span>
                                        <?php echo $status_financeiro; ?>: R$ <?php echo number_format(abs($diferenca_pedido), 2, "," , "." ); ?>
                                    </span>
                                    
                                    <!-- Indicador de status discreto -->
                                    <span class="status-indicator" 
                                          style="background-color: <?php echo $cor_status; ?>; 
                                                 box-shadow: 0 0 4px rgba(0,0,0,0.3);"></span>
                                </span>
                                
                                <!-- Ícone da calculadora (visível apenas no hover) -->
                                <i class="fas fa-calculator-alt" 
                                   style="color: <?php echo $cor_status; ?>;"
                                   data-toggle="tooltip" 
                                   data-placement="top" 
                                   title="Clique para abrir calculadora financeira"
                                   aria-hidden="true"></i>
                            </span>
                        </td><td style="width: 7%">
                                            <? echo $pedidos['data']; ?>
                                        </td>                                        <td style="width: 40px;"> 
                                            <button type="button" class="btn waves-effect waves-light btn-outline-info" data-toggle="tooltip" data-placement="top" title="" data-original-title="Editar" aria-describedby="tooltip647345">
                                                <a href="?acao=Alterar&id_pedido=<?php echo $pedidos['id'];?>">
                                                    <i class="fa fa-edit" style="font-size:20px; color:#0A94E1"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-warning waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Vendas" aria-describedby="tooltip647345">
                                                <a href="vendas.php?id_pedido=<? echo $pedidos['id'];?>&id_cliente=<? echo $pedidos['id_cliente'];?>" target="_blank">
                                                    <i class="fa fa-ticket" style="font-size:20px; color:#E1740A"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-success waves-effect waves-light" data-toggle="tooltip" data-placement="top" title="" data-original-title="Financeiro" aria-describedby="tooltip647345">
                                                <a href="financeiro_clientes.php?id_pedido=<? echo $pedidos['id'];?>&id_cliente=<? echo $pedidos['id_cliente'];?>" target="_blank">
                                                    <i class="fa fa-solid fa-badge-dollar" style="font-size:20px; color:#32CD32"></i>
                                                </a>
                                            </button>

                                            <button type="button" class="btn btn-inverse-danger waves-effect waves-light " data-toggle="tooltip" data-placement="top" title="" data-original-title="Excluir">
                                                <a href="?Excluir=ok&id_pedido=<? echo $pedidos['id']; ?>" onClick="return pergunta();">
                                                    <i class="fa fa-trash" style="font-size:20px; color:#C80306"></i>
                                                </a>
                                            </button>
                                        </td>
                                    </tr>
                                    <? } ?>                                </tbody>                            
                            </table>
                              <!-- Totais dinâmicos grudados à tabela -->
                            <div id="totais-dinamicos" style="
                                margin: 0; 
                                padding: 12px 15px; 
                                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                                border: 1px solid #dee2e6; 
                                border-top: 2px solid #007bff;
                                border-radius: 0 0 4px 4px;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                                position: relative;
                                z-index: 10;
                            ">
                                <div class="row" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px; margin: 0;">                                    <div style="font-weight: 600; color: #495057; font-size: 14px; display: flex; align-items: center;">
                                        <span style="margin-right: 8px; font-size: 16px;">📊</span>
                                        <span id="totais-label">Totais dos Dados Filtrados</span>
                                    </div>                                    <div class="totais-valores" style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#99a832; font-weight: 600; font-size: 13px;">💰 Vendas:</span> 
                                            <span id="total-vendas-filtrado" style="font-weight: 700; color: #2c5f2d; background: #d4edda; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#5ca832; font-weight: 600; font-size: 13px;">💳 Pagamentos:</span> 
                                            <span id="total-pagamentos-filtrado" style="font-weight: 700; color: #155724; background: #d1ecf1; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px;">
                                            <span style="color:#3266a8; font-weight: 600; font-size: 13px;">📈 Saldo:</span> 
                                            <span id="diferenca-total-filtrado" style="font-weight: 700; color: #004085; background: #cce7ff; padding: 2px 8px; border-radius: 12px; font-size: 13px;">R$ 0,00</span>
                                        </div>
                                    </div>
                                </div>                            </div><?
                           // CORREÇÃO: Primeiro calcular todos os totais
                           $sql_totais_completos = mysqli_query($conn,"
                               SELECT 
                                   (SELECT COALESCE(SUM(valor), 0) FROM vendas) as total_vendas_completo,
                                   (SELECT COALESCE(SUM(valor), 0) FROM financeiro_clientes) as total_pagamentos_completo,
                                   (
                                       SELECT COALESCE(SUM(v.total_vendas), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_vendas 
                                           FROM vendas 
                                           GROUP BY id_pedido
                                       ) v ON p.id = v.id_pedido
                                   ) as total_vendas_por_pedidos,
                                   (
                                       SELECT COALESCE(SUM(f.total_pagamentos), 0) 
                                       FROM pedidos p
                                       LEFT JOIN (
                                           SELECT id_pedido, SUM(valor) as total_pagamentos 
                                           FROM financeiro_clientes 
                                           GROUP BY id_pedido
                                       ) f ON p.id = f.id_pedido
                                   ) as total_pagamentos_por_pedidos
                           ");
                           
                           $totais_completos = mysqli_fetch_array($sql_totais_completos);
                           $diferenca_completa = $totais_completos['total_vendas_completo'] - $totais_completos['total_pagamentos_completo'];
                             // CORREÇÃO: Calcular registros órfãos baseado na diferença real
                           $vendas_orfas_valor = $totais_completos['total_vendas_completo'] - $totais_completos['total_vendas_por_pedidos'];
                           $pagamentos_orfaos_valor = $totais_completos['total_pagamentos_completo'] - $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // DEBUG: Forçar exibição para diagnóstico
                           $debug_vendas = $totais_completos['total_vendas_completo'];
                           $debug_vendas_pedidos = $totais_completos['total_vendas_por_pedidos']; 
                           $debug_pagamentos = $totais_completos['total_pagamentos_completo'];
                           $debug_pagamentos_pedidos = $totais_completos['total_pagamentos_por_pedidos'];
                           
                           // Contar registros órfãos para exibição
                           $vendas_orfas = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM vendas v 
                               LEFT JOIN pedidos p ON v.id_pedido = p.id 
                               WHERE p.id IS NULL OR v.id_pedido = 0 OR v.id_pedido IS NULL
                           ");
                           $vendas_orfas_result = mysqli_fetch_array($vendas_orfas);
                           
                           $pagamentos_orfaos = mysqli_query($conn,"
                               SELECT COUNT(*) as total
                               FROM financeiro_clientes f 
                               LEFT JOIN pedidos p ON f.id_pedido = p.id 
                               WHERE p.id IS NULL OR f.id_pedido = 0 OR f.id_pedido IS NULL
                           ");
                           $pagamentos_orfaos_result = mysqli_fetch_array($pagamentos_orfaos);
                           
                           ?>
                             </div>
                        </div>
                    </div>
                </div>
                  <!-- Totais Gerais do Sistema (fora do card da tabela) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-chart-line mr-2"></i>Totais Gerais do Sistema
                                <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                <span class="badge badge-danger ml-2">⚠️ Registros Órfãos</span>
                                <?php else: ?>
                                <span class="badge badge-success ml-2">✅ Dados Íntegros</span>
                                <?php endif; ?>
                            </h6>
                        </div>
                        <div class="card-body py-3">
                            <div class="row">                                <div class="col-md-8">
                                    <div style="display: flex; gap: 25px; flex-wrap: wrap; align-items: center;">
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#99a832; font-weight: 600;">💰 Total Vendas:</span>
                                            <span style="font-weight: 700; color: #2c5f2d; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_vendas_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#5ca832; font-weight: 600;">💳 Total Pagamentos:</span>
                                            <span style="font-weight: 700; color: #155724; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($totais_completos['total_pagamentos_completo'], 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 8px;">
                                            <span style="color:#3266a8; font-weight: 600;">📈 Saldo Total:</span>
                                            <span style="font-weight: 700; color: #004085; font-size: 16px;">
                                                <?php echo 'R$ '.number_format($diferenca_completa, 2, "," , "." ); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div><div class="col-md-4">
                                    <small style="color: #6c757d; line-height: 1.4;">
                                        <strong>Inclui todos os registros do sistema</strong><br>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <span style="color: #dc3545;">⚠️ Registros Órfãos Detectados:</span><br>
                                        <?php if($vendas_orfas_valor > 0): ?>
                                        • <strong>Vendas:</strong> <?php echo $vendas_orfas_result['total']; ?> registros 
                                        (R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?>)<br>
                                        <?php endif; ?>
                                        <?php if($pagamentos_orfaos_valor > 0): ?>
                                        • <strong>Pagamentos:</strong> <?php echo $pagamentos_orfaos_result['total']; ?> registros 
                                        (R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>)
                                        <?php endif; ?>
                                        <?php else: ?>
                                        <span style="color: #28a745;">✅ Nenhum registro órfão detectado</span><br>
                                        <small style="color: #999;">Todos os registros estão vinculados a pedidos válidos</small>
                                        <?php endif; ?>
                                    </small>
                                </div>
                            </div>                            
                            <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #999; font-size: 12px;">
                                    <strong>📋 Totais apenas de Pedidos Válidos (sem órfãos):</strong><br>
                                    <span style="color:#99a832;">💰 Vendas:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#5ca832;">💳 Pagamentos:</span> R$ <?php echo number_format($totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                    &nbsp;|&nbsp;
                                    <span style="color:#3266a8;">📈 Saldo:</span> R$ <?php echo number_format($totais_completos['total_vendas_por_pedidos'] - $totais_completos['total_pagamentos_por_pedidos'], 2, "," , "." ); ?>
                                </small>
                            </div>
                            <?php else: ?>
                            <div class="mt-2 pt-2 border-top">
                                <small style="color: #28a745; font-size: 12px;">
                                    <strong>✅ Todos os registros estão corretamente vinculados a pedidos válidos</strong>
                                </small>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>                
                <!-- Card de Debug/Auditoria (sempre visível para diagnóstico) -->
                <div class="col-sm-12 mt-3">
                    <div class="card <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'border-warning' : 'border-info'; ?>">
                        <div class="card-header <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'bg-warning text-dark' : 'bg-info text-white'; ?> py-2">
                            <h6 class="mb-0" style="font-size: 14px; font-weight: 600;">
                                <i class="fa fa-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'exclamation-triangle' : 'info-circle'; ?> mr-2"></i>
                                <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'Auditoria de Registros Órfãos' : 'Auditoria dos Dados (Debug)'; ?>
                                <button class="btn btn-sm btn-outline-<?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'dark' : 'light'; ?> float-right" type="button" data-toggle="collapse" data-target="#collapseOrfaos" aria-expanded="false" aria-controls="collapseOrfaos">
                                    <i class="fa fa-chevron-down"></i> Detalhes
                                </button>
                            </h6>
                        </div>
                        <div class="collapse" id="collapseOrfaos">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 style="color: #dc3545;">🔍 Análise dos Dados:</h6>
                                        <ul style="font-size: 13px; margin-bottom: 0;">
                                            <li><strong>Total Vendas Sistema:</strong> R$ <?php echo number_format($debug_vendas, 2, "," , "." ); ?></li>
                                            <li><strong>Vendas em Pedidos:</strong> R$ <?php echo number_format($debug_vendas_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Vendas:</strong> R$ <?php echo number_format($vendas_orfas_valor, 2, "," , "." ); ?> 
                                                <?php if($vendas_orfas_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $vendas_orfas_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                            <hr style="margin: 10px 0;">
                                            <li><strong>Total Pagamentos Sistema:</strong> R$ <?php echo number_format($debug_pagamentos, 2, "," , "." ); ?></li>
                                            <li><strong>Pagamentos em Pedidos:</strong> R$ <?php echo number_format($debug_pagamentos_pedidos, 2, "," , "." ); ?></li>
                                            <li><strong>Diferença Pagamentos:</strong> R$ <?php echo number_format($pagamentos_orfaos_valor, 2, "," , "." ); ?>
                                                <?php if($pagamentos_orfaos_valor > 0): ?>
                                                    <span style="color: #dc3545;">(<?php echo $pagamentos_orfaos_result['total']; ?> registros órfãos)</span>
                                                <?php else: ?>
                                                    <span style="color: #28a745;">(✓ OK)</span>
                                                <?php endif; ?>
                                            </li>
                                        </ul>
                                        
                                        <div class="mt-3">
                                            <small style="color: #666; background: #f8f9fa; padding: 8px; border-radius: 4px; display: block;">
                                                <strong>🔧 Debug Info:</strong><br>
                                                Vendas órfãs calculadas: <?php echo $vendas_orfas_valor; ?><br>
                                                Pagamentos órfãos calculados: <?php echo $pagamentos_orfaos_valor; ?><br>
                                                Condição (valor > 0): <?php echo ($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0) ? 'TRUE' : 'FALSE'; ?>
                                            </small>                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 style="color: #856404;">⚙️ Status e Recomendações:</h6>
                                        
                                        <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
                                        <div class="alert alert-warning py-2 mb-2">
                                            <strong>⚠️ Registros Órfãos Detectados</strong>
                                        </div>
                                        
                                        <h6 style="font-size: 12px; color: #dc3545; margin-bottom: 8px;">Possíveis Causas:</h6>
                                        <ul style="font-size: 12px; color: #6c757d; margin-bottom: 12px;">
                                            <?php if($vendas_orfas_valor > 0): ?>
                                            <li>Vendas com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Vendas criadas antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação das vendas</li>
                                            <?php endif; ?>
                                            <?php if($pagamentos_orfaos_valor > 0): ?>
                                            <li>Pagamentos com <code>id_pedido</code> nulo, zero ou inexistente</li>
                                            <li>Pagamentos criados antes do pedido correspondente</li>
                                            <li>Pedidos deletados após criação dos pagamentos</li>
                                            <?php endif; ?>
                                        </ul>
                                          <div style="background: #fff3cd; padding: 8px; border-radius: 4px; border-left: 3px solid #ffc107;">
                                            <small style="color: #856404;">
                                                <strong>💡 Recomendação:</strong> Verificar a integridade dos dados nas tabelas <code>vendas</code> e <code>financeiro_clientes</code>.
                                            </small>
                                        </div>
                                        
                                        <?php else: ?>
                                        <div class="alert alert-success py-2 mb-2">
                                            <strong>✅ Todos os Dados Estão Integros</strong>
                                        </div>
                                        
                                        <ul style="font-size: 12px; color: #28a745; margin-bottom: 12px;">
                                            <li>✓ Todas as vendas estão vinculadas a pedidos válidos</li>
                                            <li>✓ Todos os pagamentos estão vinculados a pedidos válidos</li>
                                            <li>✓ Não há registros órfãos no sistema</li>
                                        </ul>
                                          <div style="background: #d4edda; padding: 8px; border-radius: 4px; border-left: 3px solid #28a745;">
                                            <small style="color: #155724;">
                                                <strong>👍 Sistema OK:</strong> A integridade dos dados está mantida.
                                            </small>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>                        </div>
                    </div>
                </div>

            <div class="row page-titles">

<div class="col-md-3 align-self-center text-left">
    <div class="d-flex justify-content align-items-center">

        <button type="button" class="btn btn-primary d-lg-block m-l-15"
            onclick="location.href='?acao=Inserir';"><i class="fa fa-plus-circle"></i> Adicionar
            <? $pagina = basename($_SERVER['PHP_SELF'], '.php');
echo ucfirst(strtolower($pagina)); ?>
        </button>
    </div>
</div>
</div>


<? } ?>

<!-- Modal da Calculadora Financeira -->
<div class="modal fade modal-calculadora" id="modalCalculadora" tabindex="-1" role="dialog" aria-labelledby="modalCalculadoraLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalCalculadoraLabel">
                    <i class="fas fa-calculator mr-2"></i>
                    Calculadora Financeira
                </h5>
                <button type="button" class="btn btn-close-custom" data-dismiss="modal" aria-label="Close">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <!-- Informações do Cliente -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card status-card">
                            <div class="card-body text-center">
                                <h6 class="card-title mb-1">
                                    <i class="fas fa-user mr-2 text-primary"></i>
                                    Cliente: <span id="calc-cliente-nome" class="font-weight-bold"></span>
                                </h6>
                                <small class="text-muted">Pedido #<span id="calc-pedido-id"></span></small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Cards de Valores -->
                <div class="row mb-4">
                    <!-- Total de Vendas -->
                    <div class="col-md-4 mb-3">
                        <div class="card status-card text-center">
                            <div class="card-body">
                                <i class="fas fa-shopping-cart status-icon text-info"></i>
                                <h6 class="card-title text-muted mb-2">Total de Vendas</h6>
                                <div class="valor-destaque text-info" id="calc-vendas">R$ 0,00</div>
                            </div>
                        </div>
                    </div>

                    <!-- Total de Pagamentos -->
                    <div class="col-md-4 mb-3">
                        <div class="card status-card text-center">
                            <div class="card-body">
                                <i class="fas fa-credit-card status-icon text-success"></i>
                                <h6 class="card-title text-muted mb-2">Total Pago</h6>
                                <div class="valor-destaque text-success" id="calc-pagamentos">R$ 0,00</div>
                            </div>
                        </div>
                    </div>

                    <!-- Diferença -->
                    <div class="col-md-4 mb-3">
                        <div class="card status-card text-center">
                            <div class="card-body">
                                <i id="calc-status-icon" class="fas fa-balance-scale status-icon"></i>
                                <h6 class="card-title text-muted mb-2" id="calc-status-label">Status</h6>
                                <div class="valor-destaque" id="calc-diferenca">R$ 0,00</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Barra de Progresso -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card status-card">
                            <div class="card-body">
                                <h6 class="card-title mb-3">
                                    <i class="fas fa-chart-line mr-2 text-primary"></i>
                                    Progresso de Pagamento
                                </h6>
                                <div class="progress mb-2" style="height: 20px;">
                                    <div id="calc-progress-bar" class="progress-bar progress-bar-striped progress-bar-animated" 
                                         role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                                        <span id="calc-progress-text">0%</span>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <small class="text-muted">R$ 0,00</small>
                                    <small class="text-muted" id="calc-vendas-small">R$ 0,00</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Ações Rápidas -->
                <div class="row">
                    <div class="col-12">
                        <div class="card status-card">
                            <div class="card-body">
                                <h6 class="card-title mb-3">
                                    <i class="fas fa-bolt mr-2 text-warning"></i>
                                    Ações Rápidas
                                </h6>
                                <div class="row">
                                    <div class="col-md-6 mb-2">
                                        <button type="button" class="btn btn-outline-primary btn-block" id="btn-ver-vendas">
                                            <i class="fas fa-shopping-cart mr-2"></i>
                                            Ver Vendas
                                        </button>
                                    </div>
                                    <div class="col-md-6 mb-2">
                                        <button type="button" class="btn btn-outline-success btn-block" id="btn-ver-pagamentos">
                                            <i class="fas fa-credit-card mr-2"></i>
                                            Ver Pagamentos
                                        </button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-2">
                                        <button type="button" class="btn btn-outline-warning btn-block" id="btn-adicionar-venda">
                                            <i class="fas fa-plus mr-2"></i>
                                            Nova Venda
                                        </button>
                                    </div>
                                    <div class="col-md-6 mb-2">
                                        <button type="button" class="btn btn-outline-info btn-block" id="btn-adicionar-pagamento">
                                            <i class="fas fa-money-bill-wave mr-2"></i>
                                            Novo Pagamento
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i>
                    Fechar
                </button>
                <button type="button" class="btn btn-primary" id="btn-imprimir-relatorio">
                    <i class="fas fa-print mr-2"></i>
                    Imprimir Relatório
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Search API (Regular Expressions) table end -->
</div>
</section>



<?php include 'includes/tema/base.php'; ?>

<script>
$(document).ready(function () {
    // Change selectboxes to selectize mode to be searchable
    $("select").select2();
    
    // Verificar se a tabela já foi inicializada e destruir se necessário
    if ($.fn.DataTable.isDataTable('#footer-search')) {
        $('#footer-search').DataTable().destroy();
    }      // Initialize DataTable com configuração melhorada
    var table = $('#footer-search').DataTable({
        dom: 'Blfrtip',
        mark: true,
        buttons: {
            name: 'primary',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
        },
        "language": {
            "url": "datatable/pt-BR.json"
        },
        "pageLength": 25,
        "responsive": true,
        "processing": true,
        "info": true,
        "search": {
            "regex": true,
            "caseInsensitive": true
        },        "initComplete": function () {
            // Configurar busca no footer após inicialização completa
            setupFooterSearch();
            // Calcular totais iniciais com delay
            setTimeout(function() {
                calcularTotaisFiltrados();
                ajustarLayoutTotais();
                // Configurar observer para proteger mensagem de paginação
                configurarObserverPaginacao();
            }, 500);
        },        "drawCallback": function (settings) {
            // Recalcular totais sempre que a tabela for redesenhada (filtros, busca, paginação)
            setTimeout(function() {
                calcularTotaisFiltrados();
                ajustarLayoutTotais();
                  // Reinicializar tooltips nas novas linhas - EXCLUINDO calculadoras
                $('[data-toggle="tooltip"]:not(.calculadora-wrapper):not(.badge-calculadora)').tooltip('dispose').tooltip({
                    delay: { show: 300, hide: 100 }
                });
                
                // Reconfigurar observer de paginação após redraw
                configurarObserverPaginacao();
            }, 100);
        },"infoCallback": function(settings, start, end, max, total, pre) {
            // Personalizar a mensagem de informação para mostrar registros filtrados
            var filteredCount = settings.fnRecordsDisplay();
            var totalCount = settings.fnRecordsTotal();
            

            
            // DETECÇÃO MAIS ROBUSTA DE FILTROS ATIVOS
            var temFiltroAtivo = false;
            var motivoFiltro = [];
            
            // 1. Verificar busca global do DataTable
            try {
                var buscaGlobal = table.search();
                if (buscaGlobal && buscaGlobal.trim() !== '') {
                    temFiltroAtivo = true;
                    motivoFiltro.push('busca_global_api');
                }
            } catch (e) {

            }
            
            // 2. Verificar input de busca global diretamente no DOM
            var inputBuscaGlobal = $('.dataTables_filter input').val() || '';
            if (inputBuscaGlobal.trim() !== '') {
                temFiltroAtivo = true;
                motivoFiltro.push('busca_global_dom');
            }
            
            // 3. Verificar filtros por coluna
            try {
                if (table && table.columns) {
                    table.columns().every(function() {
                        if (this.search() && this.search().trim() !== '') {
                            temFiltroAtivo = true;
                            motivoFiltro.push('filtro_coluna');
                        }
                    });
                }
            } catch (e) {

            }
            
            // 4. Verificar inputs do footer
            $('.footer-search-input').each(function() {
                if ($(this).val() && $(this).val().trim() !== '') {
                    temFiltroAtivo = true;
                    motivoFiltro.push('footer_input');
                }
            });
            
            // 5. Verificar diferença entre registros exibidos e totais
            if (filteredCount !== totalCount) {
                temFiltroAtivo = true;
                motivoFiltro.push('diferenca_contagem');
            }
              // 6. Verificar contagem DOM como fallback
            var linhasVisiveisDOM = $('#footer-search tbody tr:visible').length;
            var totalLinhasDOM = $('#footer-search tbody tr').length;
            if (linhasVisiveisDOM < totalLinhasDOM && linhasVisiveisDOM <= 25) {
                temFiltroAtivo = true;
                motivoFiltro.push('contagem_dom');
                // Usar contagem DOM como mais confiável para registros filtrados
                filteredCount = linhasVisiveisDOM;
            }
            

            
            // Gerar mensagem apropriada
            var mensagemFinal = '';
            if (!temFiltroAtivo) {
                mensagemFinal = "Mostrando registros de " + start + " a " + end + " de um total de " + total + " registros";
            } else {
                if (filteredCount === 0) {
                    mensagemFinal = "Nenhum registro encontrado (filtrado de " + totalCount + " registros)";
                } else if (filteredCount === 1) {
                    mensagemFinal = "Mostrando 1 registro filtrado de um total de " + totalCount + " registros";
                } else {
                    // Para múltiplos registros filtrados
                    if (start === 1 && end === filteredCount) {
                        // Todos os registros filtrados estão na primeira página
                        mensagemFinal = "Mostrando " + filteredCount + " registros filtrados de um total de " + totalCount + " registros";
                    } else {
                        // Registros filtrados com paginação
                        mensagemFinal = "Mostrando registros de " + start + " a " + end + " de " + filteredCount + " registros filtrados (total: " + totalCount + " registros)";
                    }
                }
            }
            
            return mensagemFinal;
        }
    });

    // Função para ajustar layout dos totais em diferentes tamanhos de tela
    function ajustarLayoutTotais() {
        var $totais = $('#totais-dinamicos');
        var windowWidth = $(window).width();
        
        if (windowWidth < 768) {
            // Mobile: layout vertical
            $totais.find('.row').css({
                'flex-direction': 'column',
                'align-items': 'flex-start'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'column',
                'gap': '10px',
                'margin-top': '10px'
            });
        } else {
            // Desktop: layout horizontal
            $totais.find('.row').css({
                'flex-direction': 'row',
                'align-items': 'center'
            });
            $totais.find('.totais-valores').css({
                'flex-direction': 'row',
                'gap': '25px',
                'margin-top': '0'
            });
        }
    }
    
    // Ajustar layout ao redimensionar janela
    $(window).resize(function() {
        setTimeout(ajustarLayoutTotais, 100);
    });    function setupFooterSearch() {        // Aguardar um pouco para garantir renderização completa
        setTimeout(function() {
            table.columns().every(function (index) {
                var column = this;
                var title = $(column.footer()).text().trim();
                
                // Pular coluna de Ações (última coluna)
                if (index === 6) {
                    $(column.footer()).html('');
                    return;
                }
                
                if (title) {
                    // Criar input com wrapper original
                    $(column.footer()).html('<div class="md-input-wrapper"><input type="text" class="md-form-control footer-search-input" placeholder="Buscar ' + title + '" data-column="' + index + '" /></div>');
                    
                    // Configurar evento de busca com delay para melhor performance
                    var searchTimeout;
                    $('input', column.footer()).on('keyup change clear', function () {
                        var searchValue = this.value;
                        var columnIndex = $(this).data('column');
                        
                        // Limpar timeout anterior
                        clearTimeout(searchTimeout);
                        
                        // Aplicar busca com delay
                        searchTimeout = setTimeout(function() {
                            if (column.search() !== searchValue) {
                                column.search(searchValue, true, false).draw();
                                
                                // Recalcular totais após busca
                                setTimeout(function() {
                                    calcularTotaisFiltrados();
                                }, 100);
                            }
                        }, 300);
                    });
                    
                    // Prevenir ordenação ao clicar no input
                    $('input', column.footer()).on('click', function(e) {
                        e.stopPropagation();
                    });
                }            });            // Configurar busca global também - com evento mais específico e delay maior
            $('.dataTables_filter input').off('keyup.totais change.totais input.totais').on('keyup.totais change.totais input.totais', function() {
                var valorBusca = this.value;
                
                setTimeout(function() {
                    calcularTotaisFiltrados();
                    // Garantir que a paginação seja atualizada após o cálculo dos totais
                    setTimeout(function() {
                        atualizarInfoPaginacao();
                    }, 200);
                }, 500); // Delay reduzido para resposta mais rápida
            });
            
            // Adicionar evento específico para o DataTable
            table.on('search.dt', function() {
                setTimeout(function() {
                    calcularTotaisFiltrados();
                    // Sincronizar paginação com totais
                    setTimeout(function() {
                        atualizarInfoPaginacao();
                    }, 150);
                }, 200); // Delay reduzido
            });
            
            table.on('draw.dt', function() {
                setTimeout(function() {
                    calcularTotaisFiltrados();
                    // Garantir atualização da paginação após redraw
                    setTimeout(function() {
                        atualizarInfoPaginacao();
                        
                        // VERIFICAÇÃO EXTRA: Se ainda não atualizou, tentar novamente
                        setTimeout(function() {
                            var $info = $('.dataTables_info');
                            var textoAtual = $info.text();
                            if (textoAtual.includes('de um total de 1666 registros') && !textoAtual.includes('filtrados')) {
                                atualizarInfoPaginacao();
                            }
                        }, 300);
                    }, 100);
                }, 100);
            });
            
            // NOVO: Observador de mudanças mais agressivo para o input de busca
            var buscaInput = $('.dataTables_filter input')[0];
            if (buscaInput) {
                var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'attributes' && mutation.attributeName === 'value') {
                            setTimeout(function() {
                                atualizarInfoPaginacao();
                            }, 300);
                        }
                    });
                });
                
                observer.observe(buscaInput, {
                    attributes: true,
                    attributeFilter: ['value']
                });
                
                // Adicionar também evento de input para captura em tempo real
                $(buscaInput).on('input propertychange', function() {
                    setTimeout(function() {
                        atualizarInfoPaginacao();
                    }, 400);
                });
            }
            
            // NOVO: Observador para detectar se o DataTable está sobrescrevendo nossa modificação
            var infoElement = $('.dataTables_info')[0];
            if (infoElement) {
                var infoObserver = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'childList' || mutation.type === 'characterData') {
                            var textoAtual = $(infoElement).text();
                            
                            // Se detectar que voltou ao texto padrão, reaplicar nossa customização
                            if (textoAtual.includes('de um total de 1666 registros') && !textoAtual.includes('filtrados')) {
                                var inputBusca = $('.dataTables_filter input').val() || '';
                                if (inputBusca.trim() !== '') {
                                    setTimeout(function() {
                                        atualizarInfoPaginacao();
                                    }, 100);
                                }
                            }
                        }
                    });
                });
                
                infoObserver.observe(infoElement, {
                    childList: true,
                    characterData: true,
                    subtree: true
                });            }// Inicializar tooltips após tudo carregado - EXCLUINDO calculadoras
            $('[data-toggle="tooltip"]:not(.calculadora-wrapper):not(.badge-calculadora)').tooltip({
                delay: { show: 300, hide: 100 }
            });
        }, 300);
    }    function calcularTotaisFiltrados() {

        
        // Adicionar indicador visual de atualização
        $('#totais-dinamicos').addClass('updating');
          // NOVA ABORDAGEM: Verificar múltiplos seletores possíveis para o input de busca
        var valorBuscaInput1 = $('.dataTables_filter input').val() || '';
        var valorBuscaInput2 = $('input[type="search"]').val() || '';
        var valorBuscaInput3 = $('.dataTables_filter input[type="search"]').val() || '';
        var valorBuscaInput4 = $('#footer-search_filter input').val() || '';
        
        var valorBuscaInput = valorBuscaInput1 || valorBuscaInput2 || valorBuscaInput3 || valorBuscaInput4;
        var temBuscaNoInput = valorBuscaInput.trim() !== '';
        
        // CORREÇÃO DEFINITIVA: Usar settings do DataTable para obter contagens corretas
        var settings = table.settings()[0];
        var linhasVisiveisCorretas = settings.fnRecordsDisplay(); // Registros após filtros
        var totalLinhasCorretas = settings.fnRecordsTotal(); // Total de registros
        var buscaGlobal = table.search();
        
        var linhasVisiveisDOM = $('#footer-search tbody tr:visible').length;
        var totalLinhasDOM = $('#footer-search tbody tr').length;
        var diferencaDOM = linhasVisiveisDOM < totalLinhasDOM;
        
        // MELHORAR DETECÇÃO: Se há poucas linhas visíveis, sempre considerar como filtrado
        var temFiltroAtivo = temBuscaNoInput || (linhasVisiveisCorretas < totalLinhasCorretas) || diferencaDOM || (linhasVisiveisDOM <= 50 && linhasVisiveisDOM < totalLinhasCorretas);
        
            if (!temFiltroAtivo) {
            // FALLBACK: Se não detectou filtro mas há busca no input OU poucas linhas visíveis, forçar como filtrado
            if (temBuscaNoInput || linhasVisiveisDOM <= 50) {
                temFiltroAtivo = true;
            } else {
                $('#totais-label').text('Totais Gerais dos Dados');
                setTimeout(function() {
                    animarAtualizacaoValor('#total-vendas-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.vendas));
                    animarAtualizacaoValor('#total-pagamentos-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.pagamentos));
                    animarAtualizacaoValor('#diferenca-total-filtrado', 'R$ ' + formatarValor(totaisCorretosPHP.diferenca));
                    $('#totais-dinamicos').removeClass('updating');
                    // Forçar atualização da paginação para totais gerais
                    atualizarInfoPaginacao();
                }, 200);
                return;
            }
        }// Há filtros ativos - calcular totais apenas dos dados filtrados
        $('#totais-label').text('Totais dos Dados Filtrados (' + linhasVisiveisDOM + ' de ' + totalLinhasCorretas + ' registros)');
        
        var totalVendas = 0;
        var totalPagamentos = 0;
        var contadorProcessado = 0;
        
        // Forçar atualização da informação de paginação
        table.page.info();        try {
            // PRIORIZAR MÉTODO DOM - mais confiável quando há filtros visuais
            if (linhasVisiveisDOM > 0 && linhasVisiveisDOM <= 50) {
                
                $('#footer-search tbody tr:visible').each(function() {
                    var $row = $(this);
                    contadorProcessado++;
                    
                    var vendasAttr = $row.find('td[data-vendas]').attr('data-vendas');
                    var pagamentosAttr = $row.find('td[data-pagamentos]').attr('data-pagamentos');
                    
                    var vendas = parseFloat(vendasAttr) || 0;
                    var pagamentos = parseFloat(pagamentosAttr) || 0;
                    
                    if (vendas === 0 && pagamentos === 0) {
                        var vendasTexto = $row.find('td:eq(3)').text().trim();
                        var pagamentosTexto = $row.find('td:eq(4)').text().trim();
                        
                        vendas = extrairValorMonetario(vendasTexto);
                        pagamentos = extrairValorMonetario(pagamentosTexto);
                    }
                    
                    
                    totalVendas += vendas;
                    totalPagamentos += pagamentos;
                });
                
            } else {
                
                // USAR TODAS AS LINHAS FILTRADAS (não apenas a página atual)
                table.rows({ filter: 'applied' }).every(function() {
                    var $node = $(this.node());
                    contadorProcessado++;
                    
                    // Método 1: Tentar atributos data-*
                    var vendasAttr = $node.find('td[data-vendas]').attr('data-vendas');
                    var pagamentosAttr = $node.find('td[data-pagamentos]').attr('data-pagamentos');
                    
                    
                    var vendas = parseFloat(vendasAttr) || 0;
                    var pagamentos = parseFloat(pagamentosAttr) || 0;
                    
                    // Método 2: Se não funcionou, extrair do texto
                    if (vendas === 0 && pagamentos === 0) {
                        var vendasTexto = $node.find('td:eq(3)').text().trim();
                        var pagamentosTexto = $node.find('td:eq(4)').text().trim();
                        
                        
                        vendas = extrairValorMonetario(vendasTexto);
                        pagamentos = extrairValorMonetario(pagamentosTexto);
                        

                    } else {

                    }
                    
                    totalVendas += vendas;
                    totalPagamentos += pagamentos;
                });
            }
            
        } catch (error) {
            
            // Fallback: método alternativo
            $('#footer-search tbody tr:visible').each(function() {
                var $row = $(this);
                var vendasTexto = $row.find('td:eq(3)').text().trim();
                var pagamentosTexto = $row.find('td:eq(4)').text().trim();
                
                var vendas = extrairValorMonetario(vendasTexto);
                var pagamentos = extrairValorMonetario(pagamentosTexto);
                
                totalVendas += vendas;
                totalPagamentos += pagamentos;
            });
        }
        
        
        var diferenca = totalVendas - totalPagamentos;        // Atualizar elementos na página
        setTimeout(function() {
            animarAtualizacaoValor('#total-vendas-filtrado', 'R$ ' + formatarValor(totalVendas));
            animarAtualizacaoValor('#total-pagamentos-filtrado', 'R$ ' + formatarValor(totalPagamentos));
            animarAtualizacaoValor('#diferenca-total-filtrado', 'R$ ' + formatarValor(diferenca));
            $('#totais-dinamicos').removeClass('updating');
            
            // Forçar atualização da informação de paginação
            atualizarInfoPaginacao();
            
            // Aplicar força bruta após um delay adicional
            setTimeout(function() {
                forcaAtualizacaoPaginacao();
            }, 300);
        }, 200);
    }    // Variáveis globais para gerenciar paginação personalizada
    var paginationObserver = null;
    var ultimaMensagemPersonalizada = '';
    var intervaloPaginacao = null;
    var ultimaContagemDOM = 0;    // Função para forçar atualização da informação de paginação
    function atualizarInfoPaginacao() {
        try {

              setTimeout(function() {

                
                // Tentar múltiplos seletores possíveis para o elemento de paginação
                var possiveisSeletores = [
                    '.dataTables_info',
                    '.dataTable_info', 
                    '.dt-info',
                    '.datatable-info',
                    '#footer-search_info',
                    '[class*="info"]'
                ];
                
                var $info = null;
                var seletorEncontrado = '';
                
                for (var i = 0; i < possiveisSeletores.length; i++) {
                    var seletor = possiveisSeletores[i];
                    var $elemento = $(seletor);
                    if ($elemento.length > 0) {
                        $info = $elemento;
                        seletorEncontrado = seletor;

                        break;
                    }
                }
                

                
                if ($info && $info.length > 0) {

                    
                    var settings = table.settings()[0];
                    var pageInfo = table.page.info();
                    var filteredCount = settings.fnRecordsDisplay();
                    var totalCount = settings.fnRecordsTotal();
                    
                    
                    // DETECÇÃO ROBUSTA DE FILTROS ATIVOS
                    var temFiltroAtivo = false;
                    var motivoFiltro = [];
                    
                    // 1. Busca global via API
                    try {
                        var buscaGlobal = table.search();
                        if (buscaGlobal && buscaGlobal.trim() !== '') {
                            temFiltroAtivo = true;
                            motivoFiltro.push('busca_global_api');
                        }
                    } catch (e) {}
                    
                    // 2. Busca global via DOM
                    var inputBuscaGlobal = $('.dataTables_filter input').val() || '';
                    if (inputBuscaGlobal.trim() !== '') {
                        temFiltroAtivo = true;
                        motivoFiltro.push('busca_global_dom');
                    }
                    
                    // 3. Filtros por coluna
                    try {
                        if (table && table.columns) {
                            table.columns().every(function() {
                                if (this.search() && this.search().trim() !== '') {
                                    temFiltroAtivo = true;
                                    motivoFiltro.push('filtro_coluna');
                                }
                            });
                        }
                    } catch (e) {}
                    
                    // 4. Inputs do footer
                    $('.footer-search-input').each(function() {
                        if ($(this).val() && $(this).val().trim() !== '') {
                            temFiltroAtivo = true;
                            motivoFiltro.push('footer_input');
                        }
                    });
                    
                    // 5. Diferença de contagem
                    if (filteredCount !== totalCount) {
                        temFiltroAtivo = true;
                        motivoFiltro.push('diferenca_contagem');
                    }
                    
                    // 6. Contagem DOM (MÉTODO MAIS CONFIÁVEL)
                    var linhasVisiveisDOM = $('#footer-search tbody tr:visible').length;
                    var totalLinhasDOM = $('#footer-search tbody tr').length;
                    
                    
                    // CORREÇÃO PRINCIPAL: Se há poucas linhas visíveis, usar DOM como fonte
                    if (linhasVisiveisDOM < totalLinhasDOM || linhasVisiveisDOM <= 50) {
                        temFiltroAtivo = true;
                        motivoFiltro.push('contagem_dom');
                        // Usar contagem DOM como mais confiável
                        filteredCount = linhasVisiveisDOM;
                        ultimaContagemDOM = linhasVisiveisDOM;
                        
                        
                        // Ajustar também o pageInfo para ser consistente
                        if (linhasVisiveisDOM > 0) {
                            pageInfo.start = 0;
                            pageInfo.end = linhasVisiveisDOM;
                            pageInfo.recordsDisplay = linhasVisiveisDOM;
                        }
                    }

                      var novoTexto = '';
                    
                    if (!temFiltroAtivo || linhasVisiveisDOM === totalCount) {
                        novoTexto = "Mostrando registros de " + (pageInfo.start + 1) + " a " + pageInfo.end + " de um total de " + totalCount + " registros";
                    } else {
                        if (filteredCount === 0) {
                            novoTexto = "Nenhum registro encontrado (filtrado de " + totalCount + " registros)";
                        } else if (filteredCount === 1) {
                            novoTexto = "Mostrando 1 registro filtrado de um total de " + totalCount + " registros";
                        } else {
                            // Para múltiplos registros filtrados - SEMPRE mostrar como filtrados
                            novoTexto = "Mostrando " + filteredCount + " registros filtrados de um total de " + totalCount + " registros";
                        }
                    }
                    

                    
                    // Armazenar a mensagem personalizada
                    ultimaMensagemPersonalizada = novoTexto;
                    
                    // Atualizar o texto da paginação diretamente
                    $info.html(novoTexto);

                    
                    // Configurar/reconfigurar o observer para proteger contra sobrescrita
                    configurarObserverPaginacao();
                    
                    // Iniciar monitoramento contínuo se há filtros ativos
                    if (temFiltroAtivo) {
                        iniciarMonitoramentoContinuo();
                    } else {
                        pararMonitoramentoContinuo();
                    }
                    
                    // Verificar se a atualização foi aplicada
                    setTimeout(function() {

                        
                        // Se o texto não foi mantido, forçar novamente
                        if ($info.text() !== novoTexto) {

                            $info.html(novoTexto);
                            
                            // Tentar novamente após mais um delay
                            setTimeout(function() {
                                if ($info.text() !== novoTexto) {

                                    $info.html(novoTexto);
                                }
                            }, 200);
                        }
                    }, 100);                } else {

                    
                    // Debug: tentar encontrar qualquer elemento que contenha "registros"

                    var encontrados = 0;
                    $('*').each(function() {
                        var texto = $(this).text();
                        if (texto.indexOf('registros') !== -1 && texto.indexOf('Mostrando') !== -1) {
                            encontrados++;
                            if (encontrados >= 3) return false; // Limitar a 3 resultados
                        }
                    });
                    if (encontrados === 0) {

                    }
                }
            }, 150);
        } catch (e) {

        }
    }

    // Função para configurar observer que protege contra sobrescrita da mensagem de paginação
    function configurarObserverPaginacao() {
        try {
            // Desconectar observer anterior se existir
            if (paginationObserver) {
                paginationObserver.disconnect();
            }
            
            var $info = $('.dataTables_info');
            if ($info.length === 0) return;
            
            // Criar novo observer
            paginationObserver = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.type === 'childList' || mutation.type === 'characterData') {
                        var textoAtual = $info.text();
                        
                        // Se o texto foi alterado e não é nossa mensagem personalizada
                        if (ultimaMensagemPersonalizada && 
                            textoAtual !== ultimaMensagemPersonalizada && 
                            textoAtual.indexOf('filtrado') === -1 &&
                            ultimaContagemDOM > 0 && ultimaContagemDOM <= 50) {
                            
                            
                            // Restaurar nossa mensagem personalizada
                            $info.html(ultimaMensagemPersonalizada);
                        }
                    }
                });
            });
            
            // Observar mudanças no elemento de paginação
            paginationObserver.observe($info[0], {
                childList: true,
                subtree: true,
                characterData: true
            });
            

            
        } catch (e) {

        }
    }

    // Função para iniciar monitoramento contínuo da mensagem de paginação
    function iniciarMonitoramentoContinuo() {
        // Parar monitoramento anterior se existir
        if (intervaloPaginacao) {
            clearInterval(intervaloPaginacao);
        }
          // Iniciar novo monitoramento a cada 500ms
        intervaloPaginacao = setInterval(function() {
            var $info = $('.dataTables_info');
            if ($info.length > 0 && ultimaMensagemPersonalizada) {
                var textoAtual = $info.text();
                
                // Se o texto foi sobrescrito e há filtros ativos
                if (textoAtual !== ultimaMensagemPersonalizada && 
                    textoAtual.indexOf('filtrado') === -1 &&
                    ultimaContagemDOM > 0 && ultimaContagemDOM <= 50) {
                    

                    $info.html(ultimaMensagemPersonalizada);
                    
                    // Se ainda não funcionou, usar força bruta
                    setTimeout(function() {
                        if ($info.text() !== ultimaMensagemPersonalizada) {

                            forcaAtualizacaoPaginacao();
                        }
                    }, 100);
                }
            }
        }, 500);
        

    }    // Função para parar monitoramento contínuo
    function pararMonitoramentoContinuo() {
        if (intervaloPaginacao) {
            clearInterval(intervaloPaginacao);
            intervaloPaginacao = null;

        }
    }    // Função adicional para forçar atualização agressiva da paginação
    function forcaAtualizacaoPaginacao() {

        
        // Tentar múltiplos seletores possíveis para o elemento de paginação
        var possiveisSeletores = [
            '.dataTables_info',
            '.dataTable_info', 
            '.dt-info',
            '.datatable-info',
            '#footer-search_info',
            '[class*="info"]',
            '.pagination-info'
        ];
        
        var $info = null;
        var seletorEncontrado = '';
        
        for (var i = 0; i < possiveisSeletores.length; i++) {
            var seletor = possiveisSeletores[i];
            var $elemento = $(seletor);
            if ($elemento.length > 0) {
                $info = $elemento;
                seletorEncontrado = seletor;

                break;
            }
        }
        
        // Se ainda não encontrou, procurar por qualquer elemento que contenha informações de paginação
        if (!$info || $info.length === 0) {

            $('*').each(function() {
                var texto = $(this).text();
                if (texto.indexOf('registros') !== -1 && texto.indexOf('Mostrando') !== -1) {
                    $info = $(this);
                    seletorEncontrado = 'Texto com "registros"';

                    return false; // break
                }
            });
        }
        
        if ($info && $info.length > 0) {
            var linhasVisiveisDOM = $('#footer-search tbody tr:visible').length;
            var totalLinhasDOM = $('#footer-search tbody tr').length;
            
      ;
            
            if (linhasVisiveisDOM <= 50 && linhasVisiveisDOM < totalLinhasDOM) {
                var novoTexto = "Mostrando " + linhasVisiveisDOM + " registros filtrados de um total de " + totalLinhasDOM + " registros";

                
                // Usar múltiplos métodos para garantir que funcione
                $info.text(novoTexto);
                $info.html(novoTexto);
                if ($info[0]) {
                    $info[0].textContent = novoTexto;
                    $info[0].innerHTML = novoTexto;
                }
                
                // Armazenar para proteção
                ultimaMensagemPersonalizada = novoTexto;
                ultimaContagemDOM = linhasVisiveisDOM;
                

                
                return true; // Sucesso
            } else {

            }
        } else {

            
            // Debug: listar todos os elementos possíveis
            $('[class*="table"], [class*="info"], [class*="pag"]').each(function(index) {
                if (index < 10) { // Limitar para não sobrecarregar o log
                }
            });
        }
        
        return false; // Falha
    }
    
    // Função para animar atualização de valores
    function animarAtualizacaoValor(seletor, novoValor) {
        var $elemento = $(seletor);
        var valorAtual = $elemento.text();
        
        if (valorAtual !== novoValor) {
            $elemento.fadeOut(150, function() {
                $elemento.text(novoValor).fadeIn(150);
            });
        }    }
    
    // Auto-expandir card de auditoria se houver registros órfãos
    <?php if($vendas_orfas_valor > 0 || $pagamentos_orfaos_valor > 0): ?>
    setTimeout(function() {
        $('#collapseOrfaos').collapse('show');
        
        // Scroll suave até o card de auditoria
        $('html, body').animate({
            scrollTop: $('#collapseOrfaos').offset().top - 100
        }, 1000);
    }, 1500);
    <?php endif; ?>
      // Adicionar variável JavaScript com os totais corretos do PHP
    var totaisCorretosPHP = {
        vendas: <?php echo $totais_completos['total_vendas_completo']; ?>,
        pagamentos: <?php echo $totais_completos['total_pagamentos_completo']; ?>,
        diferenca: <?php echo $diferenca_completa; ?>
    };    function extrairValorMonetario(texto) {
        if (!texto) return 0;
        
        // Converter para string e remover tags HTML e espaços extra
        var textoLimpo = texto.toString()
            .replace(/<[^>]*>/g, '')         // Remove tags HTML
            .replace(/&nbsp;/g, ' ')         // Remove &nbsp;
            .replace(/\s+/g, ' ')            // Normaliza espaços
            .trim();
        
        // Remover 'R$' e outros caracteres não numéricos exceto vírgula, ponto e dígitos
        var textoNumerico = textoLimpo
            .replace(/R\$\s*/g, '')          // Remove R$
            .replace(/[^\d,.]/g, '')         // Mantém apenas dígitos, vírgula e ponto
            .trim();
        
        if (!textoNumerico) {
            return 0;
        }
        
        // Padrões para valores monetários brasileiros
        var padroes = [
            /(\d{1,3}(?:\.\d{3})*,\d{2})/,    // Ex: 1.234,56 ou 123.456,78
            /(\d+,\d{2})/,                     // Ex: 1234,56
            /(\d+\.\d{2})/,                    // Ex: 1234.56 (formato americano)
            /(\d+)/                            // Ex: 1234 (sem centavos)
        ];
        
        for (var i = 0; i < padroes.length; i++) {
            var match = textoNumerico.match(padroes[i]);
            if (match) {
                var valorStr = match[1];
                
                // Converter para formato padrão JavaScript
                if (valorStr.includes(',')) {
                    // Formato brasileiro (vírgula como decimal)
                    valorStr = valorStr.replace(/\./g, '').replace(',', '.');
                }
                
                var resultado = parseFloat(valorStr) || 0;
                return resultado;
            }
        }        
        return 0;
    }
    
    function formatarValor(valor) {
        return valor.toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }
      // Função de debug para testar manualmente no console    
    window.debugTotais = function() {

        
        table.columns().every(function(index) {
            var busca = this.search();
            if (busca !== '') {
            }
        });
        
        table.rows({ filter: 'applied' }).every(function() {
            var node = this.node();
            var $node = $(node);
        });
    };
      // Função adicional para debug da estrutura HTML
    window.debugEstruturaTabela = function() {
        
        var $tabela = $('#footer-search');
        
        if ($tabela.length > 0) {
            var $tbody = $tabela.find('tbody');
            var $linhas = $tbody.find('tr');
            
            
            $linhas.each(function(index) {
                if (index < 3) { // Mostrar apenas as 3 primeiras linhas
                    var $linha = $(this);
                   
                    
                    $linha.find('td').each(function(colIndex) {
                        var $celula = $(this);
                        var texto = $celula.text().trim();
                        var dataVendas = $celula.attr('data-vendas');
                        var dataPagamentos = $celula.attr('data-pagamentos');
                        
                        if (dataVendas || dataPagamentos || colIndex < 6) {

                        }
                    });
                }
            });
            
            // Testar busca atual
            table.rows({ filter: 'applied' }).every(function() {
                var node = this.node();
                var $node = $(node);
                var cliente = $node.find('td:eq(1)').text().trim();
                var vendas = $node.find('td:eq(3)').text().trim();
                var pagamentos = $node.find('td:eq(4)').text().trim();
                

            });
        }
    };    // Função de teste específica para busca e totais
    window.testarBuscaETotais = function(termo) {
        termo = termo || 'Eliezer';
        
        // Limpar todas as buscas
        table.search('').columns().search('').draw();
        
        setTimeout(function() {

            
            // Executar busca

            table.search(termo).draw();
            
            setTimeout(function() {

                var linhasVisiveis = table.rows({ filter: 'applied' }).count();
                var totalLinhas = table.rows().count();
                var buscaAtual = table.search();
                
          
                
                var somaVendas = 0, somaPagamentos = 0;
                var contadorLinhas = 0;
                
                table.rows({ filter: 'applied' }).every(function() {
                    contadorLinhas++;
                    var node = this.node();
                    var $node = $(node);
                    var cliente = $node.find('td:eq(1)').text().trim();
                    var vendasAttr = $node.find('td[data-vendas]').attr('data-vendas');
                    var pagamentosAttr = $node.find('td[data-pagamentos]').attr('data-pagamentos');
                    var vendasTexto = $node.find('td:eq(3)').text().trim();
                    var pagamentosTexto = $node.find('td:eq(4)').text().trim();
                    
                    var vendas = parseFloat(vendasAttr) || 0;
                    var pagamentos = parseFloat(pagamentosAttr) || 0;
                    
                    if (contadorLinhas <= 5) { // Mostrar apenas as primeiras 5

                    }
                    
                    somaVendas += vendas;
                    somaPagamentos += pagamentos;
                });
                
             
                
                calcularTotaisFiltrados();
                  setTimeout(function() {

                }, 1000);
                
            }, 1000);
        }, 500);
    };    // ===== SISTEMA DE CALCULADORA FINANCEIRA UNIFICADO =====
    
    // Variável para controlar se o modal está sendo aberto (prevenir múltiplas aberturas)
    var calculadoraAberta = false;
    
    // Função para abrir o modal da calculadora
    function abrirCalculadoraFinanceira(elemento) {
        // Prevenir múltiplas aberturas simultâneas
        if (calculadoraAberta) {
            return;
        }
        
        calculadoraAberta = true;
        
        var $wrapper = $(elemento).closest('.calculadora-wrapper');
        
        // Fechar todos os tooltips existentes para evitar sobreposição
        $('.calculadora-wrapper').tooltip('hide');
        
        // Extrair dados do pedido
        var pedidoId = $wrapper.data('pedido-id');
        var clienteNome = $wrapper.data('cliente-nome');
        var vendas = parseFloat($wrapper.data('vendas')) || 0;
        var pagamentos = parseFloat($wrapper.data('pagamentos')) || 0;
        var diferenca = parseFloat($wrapper.data('diferenca')) || 0;
        var status = $wrapper.data('status') || '';
        
        // Preencher dados do modal
        $('#calc-pedido-id').text(pedidoId);
        $('#calc-cliente-nome').text(clienteNome);
        $('#calc-vendas').text('R$ ' + formatarValor(vendas));
        $('#calc-pagamentos').text('R$ ' + formatarValor(pagamentos));
        $('#calc-vendas-small').text('R$ ' + formatarValor(vendas));
        
        // Configurar status e diferença
        var $statusIcon = $('#calc-status-icon');
        var $statusLabel = $('#calc-status-label');
        var $diferenca = $('#calc-diferenca');
        var $progressBar = $('#calc-progress-bar');
        var $progressText = $('#calc-progress-text');
        
        // Calcular porcentagem de pagamento
        var porcentagem = vendas > 0 ? (pagamentos / vendas) * 100 : 0;
        porcentagem = Math.min(100, Math.max(0, porcentagem));        // Configurar cores e ícones baseado no status
        if (status === 'Falta Pagar') {
            $statusIcon.removeClass().addClass('fas fa-exclamation-triangle status-icon text-danger')
                .css({
                    '-webkit-font-smoothing': 'antialiased',
                    '-moz-osx-font-smoothing': 'grayscale',
                    'text-rendering': 'optimizeLegibility',
                    'font-weight': '900',
                    'transform': 'translateZ(0) scale(1.002)',
                    'backface-visibility': 'hidden',
                    'filter': 'contrast(1.2) brightness(1.15) saturate(1.1)',
                    'image-rendering': 'crisp-edges',
                    'font-display': 'block',
                    'will-change': 'transform',
                    'font-variant-ligatures': 'none',
                    'font-feature-settings': '"liga" 0'
                });
            $statusLabel.text('Falta Pagar');
            $diferenca.removeClass().addClass('valor-destaque text-danger').text('R$ ' + formatarValor(diferenca));
            $progressBar.removeClass().addClass('progress-bar progress-bar-striped progress-bar-animated bg-danger');        } else if (status === 'Há a Receber') {
            $statusIcon.removeClass().addClass('fas fa-check-circle status-icon text-success')
                .css({
                    '-webkit-font-smoothing': 'antialiased',
                    '-moz-osx-font-smoothing': 'grayscale',
                    'text-rendering': 'optimizeLegibility',
                    'font-weight': '900',
                    'transform': 'translateZ(0) scale(1.002)',
                    'backface-visibility': 'hidden',
                    'filter': 'contrast(1.2) brightness(1.15) saturate(1.1)',
                    'image-rendering': 'crisp-edges',
                    'font-display': 'block',
                    'will-change': 'transform',
                    'font-variant-ligatures': 'none',
                    'font-feature-settings': '"liga" 0'
                });
            $statusLabel.text('Há a Receber');
            $diferenca.removeClass().addClass('valor-destaque text-success').text('R$ ' + formatarValor(diferenca));
            $progressBar.removeClass().addClass('progress-bar progress-bar-striped progress-bar-animated bg-success');
        } else {
            $statusIcon.removeClass().addClass('fas fa-balance-scale status-icon text-secondary')
                .css({
                    '-webkit-font-smoothing': 'antialiased',
                    '-moz-osx-font-smoothing': 'grayscale',
                    'text-rendering': 'optimizeLegibility',
                    'font-weight': '900',
                    'transform': 'translateZ(0) scale(1.002)',
                    'backface-visibility': 'hidden',
                    'filter': 'contrast(1.2) brightness(1.15) saturate(1.1)',
                    'image-rendering': 'crisp-edges',
                    'font-display': 'block',
                    'will-change': 'transform',
                    'font-variant-ligatures': 'none',
                    'font-feature-settings': '"liga" 0'
                });
            $statusLabel.text('Quitado');
            $diferenca.removeClass().addClass('valor-destaque text-secondary').text('R$ 0,00');
            $progressBar.removeClass().addClass('progress-bar progress-bar-striped progress-bar-animated bg-secondary');
        }
        
        // Atualizar barra de progresso
        $progressBar.css('width', porcentagem + '%').attr('aria-valuenow', porcentagem);
        $progressText.text(Math.round(porcentagem) + '%');
          // Configurar botões de ação rápida
        configurarAcoesRapidas(pedidoId, $wrapper.closest('tr').find('td:first').data('cliente-id') || $wrapper.data('cliente-id'));
        
        // Adicionar feedback visual de loading
        $('#modalCalculadora .modal-body').prepend('<div id="loading-calc" class="text-center mb-3"><i class="fas fa-spinner fa-spin"></i> Carregando dados...</div>');
        
        // Abrir modal com animação
        $('#modalCalculadora').modal('show');
        
        // Configurar eventos de fechamento do modal
        $('#modalCalculadora').off('hidden.bs.modal').on('hidden.bs.modal', function() {
            calculadoraAberta = false;
            $('#loading-calc').remove();
        });
        
        // Remover loading após modal aberto
        $('#modalCalculadora').off('shown.bs.modal').on('shown.bs.modal', function() {
            setTimeout(function() {
                $('#loading-calc').fadeOut(300, function() {
                    $(this).remove();
                });
            }, 500);
        });
    }
    
    // Função para configurar as ações rápidas
    function configurarAcoesRapidas(pedidoId, clienteId) {
        // Botão Ver Vendas
        $('#btn-ver-vendas').off('click').on('click', function() {
            window.open('vendas.php?id_pedido=' + pedidoId + '&id_cliente=' + clienteId, '_blank');
        });
        
        // Botão Ver Pagamentos
        $('#btn-ver-pagamentos').off('click').on('click', function() {
            window.open('financeiro_clientes.php?id_pedido=' + pedidoId + '&id_cliente=' + clienteId, '_blank');
        });
        
        // Botão Nova Venda
        $('#btn-adicionar-venda').off('click').on('click', function() {
            window.open('vendas.php?acao=Incluir&id_pedido=' + pedidoId + '&id_cliente=' + clienteId, '_blank');
        });
        
        // Botão Novo Pagamento
        $('#btn-adicionar-pagamento').off('click').on('click', function() {
            window.open('financeiro_clientes.php?acao=Incluir&id_pedido=' + pedidoId + '&id_cliente=' + clienteId, '_blank');
        });
        
        // Botão Imprimir Relatório
        $('#btn-imprimir-relatorio').off('click').on('click', function() {
            imprimirRelatorioFinanceiro(pedidoId, clienteId);
        });
    }
    
    // Função para imprimir relatório financeiro
    function imprimirRelatorioFinanceiro(pedidoId, clienteId) {
        var url = 'relatorio_financeiro.php?id_pedido=' + pedidoId + '&id_cliente=' + clienteId + '&formato=pdf';
        window.open(url, '_blank');
    }    
    // Função auxiliar para formatar valores monetários (usando a função já existente)    // Event listener ÚNICO para cliques na calculadora (evita duplicação)
    $(document).off('click.calculadora').on('click.calculadora', '.calculadora-wrapper, .badge-calculadora', function(e) {
        e.preventDefault();
        e.stopPropagation();
        e.stopImmediatePropagation(); // Impede outros handlers do mesmo evento
        
        // Se já está aberta, ignorar
        if (calculadoraAberta) {
            return false;
        }
        
        var $wrapper = $(this).closest('.calculadora-wrapper');
        
        // Fechar qualquer tooltip aberto
        $wrapper.tooltip('hide');
        
        // Feedback visual melhorado
        $wrapper.addClass('clicked');
        
        // Vibração tátil (se suportado pelo dispositivo)
        if (navigator.vibrate) {
            navigator.vibrate(50);
        }
        
        setTimeout(() => {
            $wrapper.removeClass('clicked');
        }, 200);
        
        abrirCalculadoraFinanceira(this);
        
        return false; // Impede propagação adicional
    });
      // Melhorar acessibilidade com teclado - namespace único
    $(document).off('keydown.calculadora').on('keydown.calculadora', '.calculadora-wrapper', function(e) {
        if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            e.stopPropagation();
            
            // Se já está aberta, ignorar
            if (calculadoraAberta) {
                return false;
            }
            
            // Simular efeito de clique visual
            var $this = $(this);
            $this.addClass('clicked');
            setTimeout(() => {
                $this.removeClass('clicked');
            }, 200);
            
            // Fechar tooltip antes de abrir modal
            $this.tooltip('hide');
            
            abrirCalculadoraFinanceira(this);
            return false;
        }
        
        // ESC para fechar tooltip
        if (e.key === 'Escape') {
            $(this).tooltip('hide');
        }
    });
      // Auto-mostrar hint para usuários novos (uma vez por sessão) - otimizado
    setTimeout(function() {
        if (!sessionStorage.getItem('calculadora_hint_shown') && !calculadoraAberta) {
            $('.calculadora-wrapper:first').each(function() {
                var $this = $(this);
                
                // Mostrar tooltip automaticamente como dica
                setTimeout(function() {
                    if (!calculadoraAberta) {
                        $this.trigger('mouseenter.calculadora');
                        
                        // Esconder após alguns segundos
                        setTimeout(function() {
                            $this.tooltip('hide');
                            sessionStorage.setItem('calculadora_hint_shown', 'true');
                        }, 4000);
                    }
                }, 2000);
            });
        }
    }, 3000);// Sistema unificado de hover para calculadora - tooltips ricos + animações - namespace único
    $(document).off('mouseenter.calculadora mouseleave.calculadora').on('mouseenter.calculadora', '.calculadora-wrapper', function() {
        var $this = $(this);
        
        // Se modal está aberto, não mostrar tooltip
        if (calculadoraAberta) {
            return;
        }
        
        var status = $this.data('status');
        var diferenca = parseFloat($this.data('diferenca')) || 0;
        var vendas = parseFloat($this.data('vendas')) || 0;
        var pagamentos = parseFloat($this.data('pagamentos')) || 0;
        var clienteNome = $this.data('cliente-nome');
        
        // Calcular porcentagem paga
        var porcentagemPaga = vendas > 0 ? Math.round((pagamentos / vendas) * 100) : 0;
          var tooltipText = `
            <div style="text-align: left; line-height: 1.5; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
                <strong style="color: #fff; font-size: 14px; font-weight: 600;">${clienteNome}</strong><br>
                <hr style="margin: 8px 0; border-color: rgba(255,255,255,0.3); border-width: 1px;">
                <div style="margin: 6px 0; display: flex; align-items: center;">
                    <i class="fas fa-shopping-cart" style="font-size: 14px; width: 20px; text-align: center; margin-right: 8px; color: #fff; text-shadow: 0 1px 2px rgba(0,0,0,0.3); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;"></i> 
                    <span>Vendas: <strong style="color: #fff;">R$ ${formatarValor(vendas)}</strong></span>
                </div>
                <div style="margin: 6px 0; display: flex; align-items: center;">
                    <i class="fas fa-credit-card" style="font-size: 14px; width: 20px; text-align: center; margin-right: 8px; color: #fff; text-shadow: 0 1px 2px rgba(0,0,0,0.3); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;"></i> 
                    <span>Pagamentos: <strong style="color: #fff;">R$ ${formatarValor(pagamentos)}</strong></span>
                </div>
                <div style="margin: 6px 0; padding-top: 6px; border-top: 1px solid rgba(255,255,255,0.2); display: flex; align-items: center;">
                    <i class="fas fa-chart-line" style="font-size: 14px; width: 20px; text-align: center; margin-right: 8px; color: #fff; text-shadow: 0 1px 2px rgba(0,0,0,0.3); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;"></i> 
                    <span>Progresso: <strong style="color: #fff;">${porcentagemPaga}%</strong></span>
                </div>
                <div style="margin: 6px 0; display: flex; align-items: center;">
                    <i class="fas fa-balance-scale" style="font-size: 14px; width: 20px; text-align: center; margin-right: 8px; color: #fff; text-shadow: 0 1px 2px rgba(0,0,0,0.3); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;"></i> 
                    <span>${status}: <strong style="color: #fff;">R$ ${formatarValor(diferenca)}</strong></span>
                </div>
                <hr style="margin: 8px 0; border-color: rgba(255,255,255,0.3); border-width: 1px;">
                <div style="font-style: italic; opacity: 0.9; font-size: 12px; display: flex; align-items: center;">
                    <i class="fas fa-mouse-pointer" style="font-size: 12px; width: 16px; text-align: center; margin-right: 6px; color: #fff; text-shadow: 0 1px 2px rgba(0,0,0,0.3); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;"></i> 
                    <span>Clique para abrir calculadora completa</span>
                </div>
            </div>
        `;
        
        // Configurar tooltip rico - garantir que não há duplicata
        $this.attr('title', tooltipText).attr('tabindex', '0').attr('role', 'button');
        if ($this.data('bs.tooltip')) {
            $this.tooltip('dispose');
        }        $this.tooltip({
            title: tooltipText,
            placement: 'top',
            trigger: 'manual', // Controle manual para evitar conflitos
            delay: { show: 200, hide: 100 },
            html: true,
            template: '<div class="tooltip tooltip-calculadora" role="tooltip" style="-webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale;"><div class="arrow"></div><div class="tooltip-inner" style="max-width: 340px; text-align: left; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); box-shadow: 0 8px 25px rgba(0,0,0,0.3); border-radius: 8px; padding: 12px; font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, sans-serif;"></div></div>'
        });
        
        // Mostrar com delay
        setTimeout(function() {
            if ($this.is(':hover') && !calculadoraAberta) {
                $this.tooltip('show');
            }
        }, 300);
        
        // Animação de hover - efeito pulse na badge
        $this.find('.badge-calculadora').addClass('pulse');
        $this.find('.badge-calculadora').css('animation', 'pulse-badge 2s infinite');
        
    }).on('mouseleave.calculadora', '.calculadora-wrapper', function() {
        var $this = $(this);
        
        // Esconder tooltip
        $this.tooltip('hide');
        
        // Remover animação pulse
        $this.find('.badge-calculadora').removeClass('pulse');
        
        // Restaurar animação de "respiração" após sair do hover
        setTimeout(function() {
            if (!$this.is(':hover')) {
                $this.find('.badge-calculadora').css('animation', 'expand-hint 3s ease-in-out infinite');
            }
        }, 500);
    });
      // Melhorar feedback visual ao clicar - namespace único
    $(document).off('mousedown.calculadora mouseup.calculadora').on('mousedown.calculadora', '.calculadora-wrapper', function() {
        if (!calculadoraAberta) {
            $(this).addClass('clicked');
        }
    }).on('mouseup.calculadora mouseleave.calculadora', '.calculadora-wrapper', function() {
        var $this = $(this);
        setTimeout(function() {
            $this.removeClass('clicked');
        }, 150);
    });
    
    // Efeitos sonoros (opcional) - descomente se quiser adicionar som
    /*
    function playClickSound() {
        try {
            const audio = new Audio('data:audio/wav;base64,UklGRnoGAABXQVZFZm10IBAAAAABAAEAQB8AAEAfAAABAAgAZGF0YQoGAACBhYqFbF1fdJivrJBhNjVgodDbq2EcBj+a2/LDciUFLIHO8tiJNwgZaLvt559NEAxQp+PwtmMcBjiR1/LMeSwFJHfH8N2QQAoUXrTp66hVFApGn+Dvv3AhBzaM0fPJeSAFKHjB8OWnZBYBSI');
        } catch (e) {}
    }
    */    // Log para debug
    console.log('Sistema de Calculadora Financeira Unificado carregado com sucesso!');
    
    // Debug: Verificar se há listeners duplicados
    console.log('Listeners de calculadora registrados:', $._data(document, 'events'));
    
    // Função de debug para verificar estado da calculadora
    window.debugCalculadora = function() {
        console.log('Estado da calculadora:', {
            modalAberto: calculadoraAberta,
            tooltipsVisiveis: $('.tooltip-calculadora:visible').length,
            modalsVisiveis: $('.modal-calculadora.show').length,
            wrappers: $('.calculadora-wrapper').length
        });
    };
    
    // Detectar dispositivos touch e ajustar comportamento
    if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
        $('.calculadora-wrapper').addClass('touch-device');
        
        // CSS dinâmico para dispositivos touch
        $('<style>').prop('type', 'text/css').html(`
            .calculadora-wrapper.touch-device::after {
                content: '';
                position: absolute;
                top: -2px;
                right: -2px;
                width: 6px;
                height: 6px;
                background: rgba(103, 126, 234, 0.6);
                border-radius: 50%;
                animation: touch-hint 2s ease-in-out infinite;
            }
            
            @keyframes touch-hint {
                0%, 100% { opacity: 0.6; transform: scale(1); }
                50% { opacity: 1; transform: scale(1.2); }
            }
            
            .calculadora-wrapper.touch-device:focus::after,
            .calculadora-wrapper.touch-device:active::after {
                display: none;
            }
        `).appendTo('head');    }
    
    // Função para otimizar ícones FontAwesome após carregamento
    function otimizarIconesFontAwesome() {
        // Otimização específica para fa-exclamation-triangle
        $('.fa-exclamation-triangle').each(function() {
            $(this).css({
                '-webkit-font-smoothing': 'antialiased',
                '-moz-osx-font-smoothing': 'grayscale',
                'text-rendering': 'optimizeLegibility',
                'font-weight': '900',
                'transform': 'translateZ(0) scale(1.002)',
                'backface-visibility': 'hidden',
                'filter': 'contrast(1.2) brightness(1.15) saturate(1.1)',
                'image-rendering': '-webkit-optimize-contrast',
                'font-display': 'block',
                'will-change': 'transform',
                'font-variant-ligatures': 'none',
                'font-feature-settings': '"liga" 0'
            });
        });
        
        // Otimização geral para todos os ícones FontAwesome
        $('[class*="fa-"], .fa, .fas, .far, .fal, .fab, .fad').each(function() {
            $(this).css({
                '-webkit-font-smoothing': 'antialiased',
                '-moz-osx-font-smoothing': 'grayscale',
                'text-rendering': 'optimizeLegibility',
                'image-rendering': '-webkit-optimize-contrast',
                'backface-visibility': 'hidden',
                'transform': 'translateZ(0)',
                'font-display': 'block'
            });
        });
        
        console.log('Ícones FontAwesome otimizados para máxima qualidade visual');
    }
    
    // Executar otimização após carregamento completo
    $(window).on('load', function() {
        setTimeout(otimizarIconesFontAwesome, 500);
    });
    
    // Também executar após DataTable estar pronto
    setTimeout(otimizarIconesFontAwesome, 1000);
    
    // Observer para novos elementos da calculadora (lazy loading)
    if (window.MutationObserver) {
        const calculadoraObserver = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                mutation.addedNodes.forEach(function(node) {
                    if (node.nodeType === 1) {
                        const $node = $(node);
                        if ($node.hasClass('calculadora-wrapper') || $node.find('.calculadora-wrapper').length > 0) {
                            const $newCalculadoras = $node.hasClass('calculadora-wrapper') ? $node : $node.find('.calculadora-wrapper');
                            
                            $newCalculadoras.each(function() {
                                const $calc = $(this);
                                
                                if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
                                    $calc.addClass('touch-device');
                                }
                                
                                // Inicializar eventos depois de um breve delay
                                setTimeout(function() {
                                    $calc.trigger('mouseenter.calculadora').trigger('mouseleave.calculadora');
                                }, 100);
                            });
                        }
                    }
                });
            });
        });
        
        calculadoraObserver.observe(document.body, {
            childList: true,
            subtree: true
        });
    }
});
</script>

<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>